<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Room extends Model 
{

    protected $table = 'rooms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function comfort_type()
    {
        return $this->hasOne('App\Models\ComfortType');
    }

    public function block()
    {
        return $this->hasOne('App\Models\Block');
    }

    public function types()
    {
        return $this->hasManyThrough('App\Models\RoomType', 'App\Models\RoomRoomType');
    }

}